﻿package 
{
	import flash.display.*;
	import flash.media.*;
	import flash.events.*;
	import flash.ui.Mouse;
	//importing classes
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import flash.text.AntiAliasType;
	import flash.filters.*;
	import flash.system.Security;
	import flash.net.*;
	import flash.utils.*;
	import flash.geom.*;
	import flash.ui.*;
	import caurina.transitions.*;
	import caurina.transitions.properties.FilterShortcuts;
	import caurina.transitions.properties.DisplayShortcuts;
	
	
	public class VideoPlayer extends MovieClip
	{
		//declaring our variables
		public var ncConnection:NetConnection;
		public var nStream:NetStream;
		public var video_mc:Video;
		public var videoInfo:Object;//the metaData returned at load time
		
		public var scrubLength:int = 0;
		public var comme:String = '"';
		private var textString:String;
		private var volIndex:int = 4;
		private var currTime:Number;
		
		private var soundHandler:SoundTransform = new SoundTransform();
		
		// boolean to record the scrubing and stuff
		public var added:Boolean = false;
		private var mo:Boolean = false;
		public var scrubing:Boolean = false;
		public var scrubingvol:Boolean = false;
		//global vars
		private var source:String = "";
		public var w:int = 0;
		public var h:int = 0;
		public var autoplay:String;
		private var description:String;
		
		//bolean vars
		private var muted:Boolean = false;
		private var lastVol:Number = 1;
		
		private var thumb_mc:MovieClip;
		private var thumb:String;
		private var type:String;
		public var quality:String;
		
		private var stretch:Boolean = false;
		
		public var videoWidth:int = 0;
		public var videoHeight:int = 0;
		
		private var i:int = 0;
		//YOUTUBE vars
		private var _youTubeLoader:Object;
		private var loader:Loader = new Loader();
		
		public var loadedWidth:int = 0;
		public var loadedHeight:int = 0;
		
		public function VideoPlayer(psource:String, pw:int=0, ph:int=0, pautoplay:String = "true",pthumb:String="",pdescription:String="",ptype:String="normal",pquality:String="large" )
		{
			//we set up the player to be invisible at start
			DisplayShortcuts.init(); 
			
			visible = false;
			w = pw;
			h = ph;
			source = psource;
			autoplay = pautoplay;
			thumb = pthumb;
			type = ptype;
			quality = pquality;
			
			description = pdescription;
			playpause_mc.pause_mc.visible = false;
			scrubbar_mc.scruber_mc.prog_mc.scaleX = 0;
			scrubbar_mc.scruber_mc.buf_mc.scaleX = 0;
			scrubbar_mc.scruber_mc.roll_mc.visible = false;
			
			Tweener.addTween(infobox_mc, { _autoAlpha:0, time:0 } );
			//we choose between normal player and youtube player
			if (type != "youtube")
			{
			if(stage==null)
			addEventListener(Event.ADDED_TO_STAGE, init);
			else
			init(null);
			}
			else
			{
				if(stage==null)
				addEventListener(Event.ADDED_TO_STAGE, yinit);
				else
				yinit(null);
			}
			
			
		}
		public function init(e:Event)
		{
			//we set up the stage and the connection
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			ncConnection = new NetConnection();
			ncConnection.connect(null);
			
			// we create a netstream that has tbe client the videoplayer
			nStream = new NetStream(ncConnection);
			nStream.client = this;
			nStream.bufferTime = 3;
			nStream.soundTransform = soundHandler;
			nStream.play(source);
			nStream.pause();
			nStream.addEventListener(NetStatusEvent.NET_STATUS, netstat);
		}
		public function onMetaData(info:Object):void 
		{
			//when meta data arrives we handle it
			if (autoplay == "true")
			{
			playpause_mc.play_mc.visible = false;
			playpause_mc.pause_mc.visible = true;
			nStream.resume();
			playMovie();
			}
			else
			{
				nStream.seek(0);
			}
			
			
			//function that records the metadata in video info
			videoInfo = info;
			
			if (w == 0)
			{
				videoWidth = videoInfo.width;
				videoHeight = videoInfo.height;
			}
			else
			{
				videoWidth = w;
				videoHeight = h;
			}
			
			video_mc = new Video();
			if (videoWidth != videoInfo.width)
			{
				
				if (videoInfo.width / videoInfo.height >= w / h)
				{
					video_mc.width = w;
					video_mc.height = w * (videoInfo.height / videoInfo.width);
					video_mc.x = 0;
					video_mc.y = (h - (w*(videoInfo.height / videoInfo.width)))>>1;
				}
				else
				{
					
					video_mc.width = h * (videoInfo.width / videoInfo.height);
					video_mc.height = h;
					video_mc.x = (w - (h * (videoInfo.width / videoInfo.height))) >> 1;
					video_mc.y=0
				}
			}
			else
			{
				video_mc.x = 0;
				video_mc.y = 0;
				video_mc.width = videoWidth;
				video_mc.height = videoHeight;
			}
			
			
			loadedWidth = videoWidth;
			loadedHeight = videoHeight + 28;;
				
			dispatchEvent(new Event("loaded"));
			
			
			video_mc.attachNetStream(nStream);
			video_mc.smoothing = true;
			addChildAt(video_mc, 1);
			//we add the video player on stage
			
			thumb_mc = new VideoThumb(thumb, videoWidth, videoHeight + 28);
			
			
			addChildAt(thumb_mc, numChildren - 2);
			
			
			scrubbar_mc.scruber_mc.roll_mc.mouseChildren = false;
			scrubbar_mc.scruber_mc.roll_mc.mouseEnabled = false;
			
			scrubbar_mc.scruber_mc.buttonMode = true;
			scrubbar_mc.scruber_mc.mouseChildren = false;
			
			playbtn_mc.buttonMode = true;
			playbtn_mc.mouseChildren = false;

			
			
			
			setupButtons();
			arrangeIcons();
			
			if (autoplay == "true")
			{
				//visible = true;
				thumb_mc.visible = false;
			}
			else
			thumb_mc.addEventListener("loaded", thumbLoaded);
			
			if (thumb == '') visible = true;
		}
		public function arrangeIcons()
		{
			
			resizePlayer(videoWidth, videoHeight + 28);
		}
		public function thumbLoaded(e:Event)
		{
			visible = true;
			
		}
		public function handleMouseEvents(e:MouseEvent)
		{
			//function which handles almost all the mosue events
			//--------------------------------------------------
			if (e.type == "rollOver")
			{
				
				Tweener.addTween(e.currentTarget, { _frame:30, time:1 } );
				if (e.currentTarget.name == "info_mc")
				{
					Tweener.addTween(infobox_mc, { _autoAlpha:1, time:.7 } );
				}
			}
			if (e.type == "rollOut")
			{
				if (e.currentTarget.name != "vol_mc")
				{
				Tweener.addTween(e.currentTarget, { _frame:1, time:1 } );
				if (e.currentTarget.name == "info_mc")
				{
					Tweener.addTween(infobox_mc, { _autoAlpha:0, time:.7 } );
				}
				
				}
				else
				{
					if (scrubingvol == false)
					Tweener.addTween(e.currentTarget, { _frame:1, time:1 } );
				}
			}
			if (e.type == "mouseDown")
			{
				if (e.currentTarget.name == "playbtn_mc")
				{
					
					playMovie();
					
				}
				if (e.currentTarget.name == "playpause_mc")
				{
					if (e.currentTarget.play_mc.visible == true)
					{
						playMovie();
					}
					else
					{
						if (type != "youtube")
						{
						nStream.pause();
						
						}
						else
						{
							_youTubeLoader.pauseVideo();
						}
						playpause_mc.play_mc.visible = true;
						playpause_mc.pause_mc.visible = false;
						playbtn_mc.visible = true;
					}
				}
				if (e.currentTarget.name == "slider_mc")
				{
					scrubingvol = true;
					
				}
				if (e.currentTarget.name == "vol_icon")
				{
					if (type != "youtube")
					{
					if (muted == false)
					{
						
						muted = true;
						lastVol = soundHandler.volume;
						soundHandler.volume = 0;
						vol_mc.vol_icon.vol_ammount.scaleX = 0;
						vol_mc.slider_mc.slider_mc.y = 44;
						
					}
					else
					{
						muted = false;
						soundHandler.volume = lastVol;
						
						vol_mc.vol_icon.vol_ammount.scaleX = lastVol;
						vol_mc.slider_mc.slider_mc.y = 4 + (1 - lastVol) * 40;
					}
					nStream.soundTransform = soundHandler;
					}
					else
					{
						
						if (muted == false)
						{
							//mute handler
							muted = true;
							lastVol = _youTubeLoader.getVolume();
							_youTubeLoader.setVolume(0);
							vol_mc.vol_icon.vol_ammount.scaleX = 0;
							vol_mc.slider_mc.slider_mc.y = 44;
							
						}
						else
						{
							muted = false;
							_youTubeLoader.setVolume(lastVol);
							
							vol_mc.vol_icon.vol_ammount.scaleX = lastVol/100;
							vol_mc.slider_mc.slider_mc.y = 4 + (1 - lastVol/100) * 40;
						}
						
					}
					vol_mc.slider_mc.blackslider_mc.height = vol_mc.slider_mc.slider_mc.y;
				}
				if (e.currentTarget.name == "full_mc")
				{
					//basic full screen function
					if (stage.displayState == StageDisplayState.NORMAL)
					{
						stage.displayState = StageDisplayState.FULL_SCREEN;
						
					}
					else 
					
					{
						stage.displayState = StageDisplayState.NORMAL;
					}
				}
			}
			//--------------------------------------------------
		}
		public function netstat(e:NetStatusEvent)
		{
			//if player has reached end
			if (e.info.code == "NetStream.Play.Stop")
			{
				openReplay();
				
			}
        
		}
		public function handleFrame(e:Event)
		{
			//frame handler - for simple player
			if (type != "youtube")
			{
			if (nStream.bufferLength >= nStream.bufferTime)
			{
				buffer_mc.visible = false;
			}
			else
			{
				buffer_mc.visible = true;
			}
			
			
			if (nStream.time > int(videoInfo.duration) - nStream.bufferTime)
			{
				buffer_mc.visible = false;
			}
			
			if (scrubing == true)
			{
				
				var ratio:Number = scrubbar_mc.scruber_mc.mouseX / scrubLength;
				
				if (ratio > 1) ratio = 1;
				if (ratio < 0) ratio = 0;
				
				nStream.seek(Number(ratio * videoInfo.duration));
				scrubbar_mc.scruber_mc.prog_mc.width = ratio * scrubLength;
				
			}
			else
			{
				if (((nStream.time / Number(videoInfo.duration) ) * scrubLength) > scrubLength)
				{
					Tweener.addTween(scrubbar_mc.scruber_mc.prog_mc, { width:scrubLength, time:0.3 } );
				}
				else
				Tweener.addTween(scrubbar_mc.scruber_mc.prog_mc, { width:(nStream.time / Number(videoInfo.duration) ) * scrubLength, time:0.3 } );
				
				
					
			}
			//we verify if volume is scrubbing
			if (scrubingvol == true)
			{
				volIndex = vol_mc.slider_mc.mouseY;
				if (volIndex < 4) volIndex = 4;
				if (volIndex > 44) volIndex = 44;
				
				vol_mc.slider_mc.slider_mc.y = volIndex;
				vol_mc.slider_mc.blackslider_mc.height = volIndex;
				soundHandler.volume = Math.abs(1 - ((volIndex - 4) / 40));
				nStream.soundTransform = soundHandler;
				vol_mc.vol_icon.vol_ammount.scaleX=Math.abs(1 - ((volIndex - 4) / 40));
			}
			
			
			
			currTime = nStream.time;
				
			if (currTime > videoInfo.duration)
			{
				currTime = videoInfo.duration;
			}
				
			textString = String(formatTime(currTime)) + "<font color=" + comme + "#999999" + comme + "> / " + formatTime(videoInfo.duration);
			scrubbar_mc.text_txt.htmlText = textString;
			
			
			scrubbar_mc.scruber_mc.buf_mc.width = (nStream.bytesLoaded / nStream.bytesTotal ) * scrubLength;
			
			
			}
			else
			{
				//********************
				//YOU TUBE ENTER FRAME
				//********************
				if (scrubing == true)
				{
				
				var yratio:Number = scrubbar_mc.scruber_mc.mouseX / scrubLength;
				
				if (yratio > 1) yratio = 1;
				if (yratio < 0) yratio = 0;
				
				
				_youTubeLoader.seekTo(Number(yratio * _youTubeLoader.getDuration()),true);
				scrubbar_mc.scruber_mc.prog_mc.width = yratio * scrubLength;
				
				}
				else
				{
				if (((_youTubeLoader.getCurrentTime() / _youTubeLoader.getDuration() ) * scrubLength) > scrubLength)
				{
					Tweener.addTween(scrubbar_mc.scruber_mc.prog_mc, { width:scrubLength, time:0.3 } );
				}
				else
				Tweener.addTween(scrubbar_mc.scruber_mc.prog_mc, { width:(_youTubeLoader.getCurrentTime() / _youTubeLoader.getDuration() ) * scrubLength, time:0.3 } );	
				}
				
				
				
				
				textString = String(formatTime(_youTubeLoader.getCurrentTime())) + "<font color=" + comme + "#999999" + comme + "> / " + formatTime(_youTubeLoader.getDuration());
				scrubbar_mc.text_txt.htmlText = textString;
				scrubbar_mc.scruber_mc.buf_mc.x = (_youTubeLoader.getVideoStartBytes / _youTubeLoader.getVideoBytesTotal()) * scrubLength;
				scrubbar_mc.scruber_mc.buf_mc.width =  + (_youTubeLoader.getVideoBytesLoaded() / _youTubeLoader.getVideoBytesTotal() ) * scrubLength;
			
				//test if mouse is over the scruber
				if (scrubingvol == true)
				{
				volIndex = vol_mc.slider_mc.mouseY;
				if (volIndex < 4) volIndex = 4;
				if (volIndex > 44) volIndex = 44;
				
				vol_mc.slider_mc.slider_mc.y = volIndex;
				vol_mc.slider_mc.blackslider_mc.height = volIndex;
				
				_youTubeLoader.setVolume(Math.abs(1 - ((volIndex - 4) / 40))*100);
				vol_mc.vol_icon.vol_ammount.scaleX=Math.abs(1 - ((volIndex - 4) / 40));
				}
			
			
			}
			if (mo == true || scrubing == true)
			{
				
				var index:int = scrubbar_mc.scruber_mc.mouseX;
				if (index < 0) index = 0;
				if (index > scrubbar_mc.scruber_mc.bg_mc.width-4) index = scrubbar_mc.scruber_mc.bg_mc.width-4;
				scrubbar_mc.scruber_mc.roll_mc.x = index;
				
				if(type!="youtube")
				scrubbar_mc.scruber_mc.roll_mc.text_txt.text = String(formatTime((index / scrubbar_mc.scruber_mc.bg_mc.width) * videoInfo.duration));
				else
				scrubbar_mc.scruber_mc.roll_mc.text_txt.text = String(formatTime((index / scrubbar_mc.scruber_mc.bg_mc.width) * _youTubeLoader.getDuration()));
				
				
				scrubbar_mc.scruber_mc.roll_mc.visible = true;
			}
			if (mo == false && scrubing==false)
			{
				
				scrubbar_mc.scruber_mc.roll_mc.visible = false;
			}
			
		}
		public function checkScrub(e:MouseEvent)
		{
			if (e.type == "rollOver")
			{
				
				mo = true;
				
			}
			if (e.type == "rollOut")
			{
				mo = false;
			}
			if (e.type == "mouseDown")
			{
				scrubing = true;
				thumb_mc.visible = false;
			}
			if (e.type == "mouseUp")
			{
				scrubing = false;
				scrubingvol = false;
				
				Tweener.addTween(vol_mc, { _frame:1, time:1 } );
			}
		}
		public function formatTime(t:int):String 
		{
			// returns the minutes and seconds with leading zeros
			// for example: 70 returns 01:10
			var s:int = Math.round(t);
			var m:int = 0;
			if (s > 0) {
				while (s > 59) {
					m++;
					s -= 60;
				}
				return String((m < 10 ? "0" : "") + m + ":" + (s < 10 ? "0" : "") + s);
			} else {
				return "00:00";
			}
		}
		public function openReplay() 
		{
			//handle the end of the video
			//---------------------------
			if (type != "youtube")
			{
			nStream.pause();
			nStream.seek(1);
			}
			else
			{
				_youTubeLoader.seekTo(0,true);
				_youTubeLoader.pauseVideo();
			}
			playpause_mc.play_mc.visible = true;
			playpause_mc.pause_mc.visible = false;
			playbtn_mc.visible = true;
			scrubing = false;
			scrubingvol = false;
			
			thumb_mc.visible = true;
			//---------------------------
		}
		public function playMovie()
		{
			if(type!="youtube")
			nStream.resume();
			else
			_youTubeLoader.playVideo();
					
			if (thumb_mc != null)
			{
				thumb_mc.visible = false;
			}
			playbtn_mc.visible = false;
			playpause_mc.play_mc.visible = false;
			playpause_mc.pause_mc.visible = true;
		}
		
		
		
		public function handleFullScreen(e:FullScreenEvent)
		{
			//fucntion which handle the FULLSCREEN event
			//******************************************
			if (stage.displayState == StageDisplayState.NORMAL)
			{
				full_mc.gotoAndStop(1);
				if (type != "youtube")
				{
				if (videoWidth != videoInfo.width)
				{
					
					if (videoInfo.width / videoInfo.height >= w / h)
					{
						video_mc.width = w;
						video_mc.height = w * (videoInfo.height / videoInfo.width);
						video_mc.x = 0;
						video_mc.y = (h - (w*(videoInfo.height / videoInfo.width)))>>1;
					}
					else
					{
						
						video_mc.width = h * (videoInfo.width / videoInfo.height);
						video_mc.height = h;
						video_mc.y = 0;
						video_mc.x = (w - (h * (videoInfo.width / videoInfo.height)))>>1;
					}
				}
				else
				{
					video_mc.y = 0;
					video_mc.x = 0;
					video_mc.width = videoWidth;
					video_mc.height = videoHeight;
				}
				}
				else
				{
					if (w == 0)
					{
						videoWidth = 640;
						videoHeight = 480;
					}
					else
					{
						videoWidth = w;
						videoHeight = h;
					}
					_youTubeLoader.x = 0;
					_youTubeLoader.y = 0;
					_youTubeLoader.width = videoWidth;
					_youTubeLoader.height = videoHeight;
				}
				arrangeIcons();
				if (thumb_mc.l.content != null)
				{
					thumb_mc.l.content.width = videoWidth;
					thumb_mc.l.content.height = videoHeight;
					
				}
				this.x = -loadedWidth / 2;
				this.y = -loadedHeight / 2;
				
			}
			else
			{
				if (type != "youtube")
				{
				if (videoInfo.width / videoInfo.height >= stage.stageWidth / (stage.stageHeight - 28))
				{
					video_mc.width = stage.stageWidth;
					video_mc.height = stage.stageWidth * (videoInfo.height / videoInfo.width);
					video_mc.x = 0;
					video_mc.y = ((stage.stageHeight-28) - (stage.stageWidth*(videoInfo.height / videoInfo.width)))>>1;
				}
				else
				{
					video_mc.width = (stage.stageHeight-28) * (videoInfo.width / videoInfo.height);
					video_mc.height = stage.stageHeight - 28;
					video_mc.x = (stage.stageWidth - ((stage.stageHeight - 28) * (videoInfo.width / videoInfo.height))) >> 1;
					video_mc.y = 0;
				}
				}
				else
				{
					if (320 / 240 >= stage.stageWidth / (stage.stageHeight - 28))
					{
						_youTubeLoader.width = stage.stageWidth;
						_youTubeLoader.height = stage.stageWidth * (9 / 16);
						_youTubeLoader.x = 0;
						_youTubeLoader.y = ((stage.stageHeight-28) - (stage.stageWidth*(9 / 16)))>>1;
					}
					else
					{
						_youTubeLoader.width = (stage.stageHeight-28) * (16 / 9);
						_youTubeLoader.height = stage.stageHeight - 28;
						_youTubeLoader.x = (stage.stageWidth - ((stage.stageHeight - 28) * (16 / 9))) >> 1;
						_youTubeLoader.y = 0;
					}
					
				}
				
				this.x = this.x + loadedWidth / 2 - stage.stageWidth / 2;
				this.y = this.y + loadedHeight / 2 - stage.stageHeight / 2;
				
				resizePlayer(stage.stageWidth, stage.stageHeight);
				
				if (thumb_mc.l.content != null)
				{
					thumb_mc.l.content.width = stage.stageWidth;
					thumb_mc.l.content.height = stage.stageHeight-28;
					
				}
				
			}
			//******************************************
		}
		
		//*******************
		//YOUTUBE INTEGRATION
		//*******************
		
		public function yinit(e:Event)
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			
			loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit);
			loader.load(new URLRequest("http://www.youtube.com/apiplayer?version=3"));
			
			Security.allowDomain("*");
			
			
		}
		public function onLoaderInit(event:Event):void {
			
			addChildAt(loader,1);
			loader.content.addEventListener("onReady", onPlayerReady);
			loader.content.addEventListener("onError", onPlayerError);
			loader.content.addEventListener("onStateChange", onPlayerStateChange);
			loader.content.addEventListener("onPlaybackQualityChange", onVideoPlaybackQualityChange);
		}
		public function onVideoPlaybackQualityChange(event:Event):void {
			// Event.data contains the event parameter, which is the new video quality
			trace("video quality:", Object(event).data);
		}
		
		public function onPlayerReady(event:Event):void {
			// Event.data contains the event parameter, which is the Player API ID 
			//trace("player ready:", Object(event).data);
		
			// Once this event has been dispatched by the player, we can use
			// cueVideoById, loadVideoById, cueVideoByUrl and loadVideoByUrl
			// to load a particular YouTube video.
			_youTubeLoader = loader.content;
			// Set appropriate player dimensions for your application
			
			
			if (w == 0)
			{
				videoWidth = 640;
				videoHeight = 480;
			}
			else
			{
				videoWidth = w;
				videoHeight = h;
			}
			
			_youTubeLoader.setSize(videoWidth, videoHeight);
			
				
			_youTubeLoader.loadVideoById(source,0,String(quality));
			
			
			loadedWidth = videoWidth;
			loadedHeight = videoHeight + 28;;
				
			dispatchEvent(new Event("loaded"));
			
			if (autoplay == "true")
			{
			playpause_mc.play_mc.visible = false;
			playpause_mc.pause_mc.visible = true;
			
			//playMovie();
			}
			else
			{
				_youTubeLoader.seekTo(0,true);
				_youTubeLoader.pauseVideo();
			}
			
		
			
			thumb_mc = new Asset(thumb, videoWidth, videoHeight+28);
			addChildAt(thumb_mc, numChildren - 2);
			
			arrangeIcons();
			
			scrubbar_mc.scruber_mc.roll_mc.mouseChildren = false;
			scrubbar_mc.scruber_mc.roll_mc.mouseEnabled = false;
			
			scrubbar_mc.scruber_mc.buttonMode = true;
			scrubbar_mc.scruber_mc.mouseChildren = false;
			
			playbtn_mc.buttonMode = true;
			playbtn_mc.mouseChildren = false;
			
			
			
			if (autoplay == "true")
			{
				visible = true;
				thumb_mc.visible = false;
				playbtn_mc.visible = false;
				
			}
			else
			{
			thumb_mc.addEventListener("loaded", thumbLoaded);
			}
			
			if (thumb == '') visible = true;
			
			buffer_mc.visible = false;
			
			
			
			setupButtons();
		}

		public function onPlayerError(event:Event):void {
			// Event.data contains the event parameter, which is the error code
			//trace("player error:", Object(event).data);
		}

		public function onPlayerStateChange(event:Event):void {
			// Event.data contains the event parameter, which is the new player state
			
			if (Object(event).data == 3)
			{
				buffer_mc.visible = true;
			}
			else
			{
				buffer_mc.visible = false;
			}
			if (Object(event).data == 0)
			{
				openReplay();
			}
			
		}

		
		
		private function setupButtons()
		{
			
			addListeners(playpause_mc,info_mc,full_mc,vol_mc,playbtn_mc);
			
			vol_mc.slider_mc.addEventListener(MouseEvent.MOUSE_DOWN, handleMouseEvents);
			vol_mc.vol_icon.addEventListener(MouseEvent.MOUSE_DOWN, handleMouseEvents);
			
			stage.addEventListener(FullScreenEvent.FULL_SCREEN, handleFullScreen);
			scrubbar_mc.scruber_mc.addEventListener(MouseEvent.ROLL_OUT, checkScrub);
			scrubbar_mc.scruber_mc.addEventListener(MouseEvent.ROLL_OVER, checkScrub);
			scrubbar_mc.scruber_mc.addEventListener(MouseEvent.MOUSE_DOWN, checkScrub);
			stage.addEventListener(MouseEvent.MOUSE_UP, checkScrub);
			
			stage.addEventListener(Event.ENTER_FRAME, handleFrame);
			/*
			addEventListener(Event.REMOVED_FROM_STAGE, handleDestroy);*/
			//*********************************************
		}
		/*private function youTubePlayerStateChangeHandler (event:YouTubeLoaderEvent):void {
			//handle the youtube player events
			
		};*/
		public function destroy()
		{
			Tweener.addTween(this, { _autoAlpha:0, time:1, onComplete:completeDestroy } );
			if (type != "youtube")
			{
				nStream.pause();
			}
			else
			{
				_youTubeLoader.stopVideo();
				_youTubeLoader.destroy();
			}
		}
		private function completeDestroy()
		{
			Object(parent).removeChild(this);
			
		}
		public function handleDestroy(e:Event)
		{
			//function which stops the video and removes all listeners to release memory
			playpause_mc.removeEventListener(MouseEvent.ROLL_OVER, handleMouseEvents);
			playpause_mc.removeEventListener(MouseEvent.ROLL_OUT, handleMouseEvents);
			playpause_mc.removeEventListener(MouseEvent.MOUSE_DOWN, handleMouseEvents);
			
			info_mc.removeEventListener(MouseEvent.ROLL_OVER, handleMouseEvents);
			info_mc.removeEventListener(MouseEvent.ROLL_OUT, handleMouseEvents);
			
			full_mc.removeEventListener(MouseEvent.ROLL_OVER, handleMouseEvents);
			full_mc.removeEventListener(MouseEvent.ROLL_OUT, handleMouseEvents);
			full_mc.removeEventListener(MouseEvent.MOUSE_DOWN, handleMouseEvents);
			
			vol_mc.removeEventListener(MouseEvent.ROLL_OVER, handleMouseEvents);
			vol_mc.removeEventListener(MouseEvent.ROLL_OUT, handleMouseEvents);
			
			vol_mc.slider_mc.removeEventListener(MouseEvent.MOUSE_DOWN, handleMouseEvents);
			vol_mc.vol_icon.removeEventListener(MouseEvent.MOUSE_DOWN, handleMouseEvents);
			
			playbtn_mc.removeEventListener(MouseEvent.ROLL_OVER, handleMouseEvents);
			playbtn_mc.removeEventListener(MouseEvent.ROLL_OUT, handleMouseEvents);

			playbtn_mc.removeEventListener(MouseEvent.MOUSE_DOWN, handleMouseEvents);
			
			scrubbar_mc.scruber_mc.removeEventListener(MouseEvent.ROLL_OUT, checkScrub);
			scrubbar_mc.scruber_mc.removeEventListener(MouseEvent.ROLL_OVER, checkScrub);
			scrubbar_mc.scruber_mc.removeEventListener(MouseEvent.MOUSE_DOWN, checkScrub);
			stage.removeEventListener(MouseEvent.MOUSE_UP, checkScrub);
			
			stage.removeEventListener(Event.ENTER_FRAME, handleFrame);
			stage.removeEventListener(FullScreenEvent.FULL_SCREEN, handleFullScreen);
			
		}
		public function addListeners(... objects)
		{
			for (i = 0; i < objects.length; i++)
			{
				objects[i].gotoAndStop(1);
				objects[i].buttonMode = true;
				objects[i].addEventListener(MouseEvent.ROLL_OVER, handleMouseEvents);
				objects[i].addEventListener(MouseEvent.ROLL_OUT, handleMouseEvents);
				objects[i].addEventListener(MouseEvent.MOUSE_DOWN, handleMouseEvents);
			}
		}
		public function resizePlayer(wd:int, hg:int)
		{
			//arranging the controls
			playpause_mc.y = hg-28;
			scrubbar_mc.y = hg-28;
			info_mc.y = hg-28;
			vol_mc.y = hg-28;
			full_mc.y = hg-28;
			bg_mc.width = wd;
			bg_mc.height = hg;
			
			//setting up the description
			infobox_mc.text_txt.htmlText = description;
			infobox_mc.text_txt.width = wd-10;
			infobox_mc.text_txt.autoSize = TextFieldAutoSize.LEFT;
			infobox_mc.bg_mc.width = wd;
			infobox_mc.bg_mc.height = infobox_mc.text_txt.textHeight + 10;
			infobox_mc.y = hg - 28 - infobox_mc.bg_mc.height;
			
			
			
			playbtn_mc.x = wd / 2 - (playbtn_mc.width >> 1);
			playbtn_mc.y = hg / 2 - (playbtn_mc.height >> 1);
			
			
			
			
			if(description!='')
			{
				info_mc.x = wd - 98;
				scrubbar_mc.bg_mc.width = wd - 132;
				scrubbar_mc.scruber_mc.bg_mc.width = scrubbar_mc.bg_mc.width - 106;
				scrubLength = scrubbar_mc.scruber_mc.bg_mc.width;
				
			}
			else
			{
				info_mc.visible = false;	
				scrubbar_mc.bg_mc.width = wd - 99;
				scrubbar_mc.scruber_mc.bg_mc.width = scrubbar_mc.bg_mc.width - 106;
				scrubLength = scrubbar_mc.scruber_mc.bg_mc.width;
			}
			vol_mc.x = wd - 65;
			full_mc.x = wd - 32;
			scrubbar_mc.text_txt.x = scrubbar_mc.bg_mc.width - 86;
			
			if (thumb_mc != null)
			{
			thumb_mc.bg.width = wd;
			thumb_mc.bg.height = hg - 28;
			}
		}
		public function forceResize(wd:int, hg:int)
		{
			if (type == "video")
			{
				video_mc.width = wd;
				video_mc.height = hg-28;
				
			}
			if (type == "youtube")
			{
				_youTubeLoader.setSize(wd, hg-28);
			}
			videoWidth = wd;
			videoHeight = hg-28;
		}


	}
}